 /* smooth nav script */
 document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function (e) {
        e.preventDefault();

        const targetId = this.getAttribute('href').substring(1);
        const target = document.getElementById(targetId);

        if (target) {
            let offset = target.offsetTop - 100; 

            if (window.innerWidth < 768) {
   
                offset -= 250; 
            }

            window.scrollTo({
                top: offset,
                behavior: 'smooth',
            });
        }
    });
});
        
var floatingPic = document.getElementById('floating-pic');


floatingPic.style.animation = 'floatAnimation 3s infinite'; 

document.addEventListener("DOMContentLoaded", function() {
    var navLinks = document.querySelectorAll('.navbar-nav .nav-link');

    navLinks.forEach(function(navLink) {
        navLink.addEventListener('click', function() {
            var navbarToggler = document.querySelector('.navbar-toggler');
            var navbarCollapse = document.querySelector('.navbar-collapse');

            if (navbarToggler && navbarCollapse.classList.contains('show')) {
                navbarToggler.click(); 
            }
        });
    });
});