const quizData = [
    {
        question: "What is HTML?",
        answers: {
            a: "A programming language",
            b: "A markup language",
            c: "A scripting language",
            d: "A database"
        },
        correctAnswer: "b"
    },
    {
        question: "What is CSS used for?",
        answers: {
            a: "Styling web pages",
            b: "Creating databases",
            c: "Server-side scripting",
            d: "Analyzing data"
        },
        correctAnswer: "a"
    },
    {
        question: "What does JavaScript allow you to do?",
        answers: {
            a: "Style web pages",
            b: "Program server-side logic",
            c: "Make websites interactive",
            d: "Create databases"
        },
        correctAnswer: "c"
    },
    {
        question: "Which tag is used for creating hyperlinks in HTML?",
        answers: {
            a: "<hyperlink>",
            b: "<url>",
            c: "<link>",
            d: "<a>"
        },
        correctAnswer: "d"
    },
    {
        question: "What is the purpose of the <head> element in HTML?",
        answers: {
            a: "To define the page content",
            b: "To contain metadata about the document",
            c: "To create a clickable link",
            d: "To display a header at the top of the page"
        },
        correctAnswer: "b"
    },
    {
        question: "Which CSS property is used to change the text color of an element?",
        answers: {
            a: "background-color",
            b: "font-size",
            c: "color",
            d: "text-align"
        },
        correctAnswer: "c"
    },
    {
        question: "What is the largest heading tag in HTML?",
        answers: {
            a: "<h1>",
            b: "<h2>",
            c: "<h3>",
            d: "<h4>"
        },
        correctAnswer: "a"
    },
    {
        question: "What is the primary purpose of JavaScript's 'if' statement?",
        answers: {
            a: "To declare a variable",
            b: "To loop through an array",
            c: "To conditionally execute code",
            d: "To define a function"
        },
        correctAnswer: "c"
    },
    {
        question: "What is the standard markup language for creating web pages?",
        answers: {
            a: "JavaScript",
            b: "Python",
            c: "Java",
            d: "Hypertext Markup Language (HTML)"
        },
        correctAnswer: "d"
    },
    {
        question: "What is the correct way to comment out code in HTML?",
        answers: {
            a: "<!-- This is a comment -->",
            b: "// This is a comment",
            c: "/* This is a comment */",
            d: "-- This is a comment --"
        },
        correctAnswer: "a"
    }
];

const quizForm = document.getElementById("quizForm");
const submitButton = document.getElementById("submitQuiz");
const resultContainer = document.getElementById("quizForm"); // Use the quizForm container to display the score

let currentQuestionIndex = 0;
let score = 0;

function displayQuestion() {
    if (currentQuestionIndex < quizData.length) {
        const question = quizData[currentQuestionIndex];

        const questionElement = document.createElement("div");
        questionElement.classList.add("question");

        const questionText = document.createElement("p");
        questionText.textContent = `${currentQuestionIndex + 1}. ${question.question}`;
        questionElement.appendChild(questionText);

        // Creates a container for options A and B
        const optionsABContainer = document.createElement("div");
        optionsABContainer.classList.add("options-container");

        // Creates a container for options C and D
        const optionsCDCOntainer = document.createElement("div");
        optionsCDCOntainer.classList.add("options-container");

        for (const option in question.answers) {
            const answerLabel = document.createElement("label");
            const answerInput = document.createElement("input");
            answerInput.type = "radio";
            answerInput.name = `question${currentQuestionIndex}`;
            answerInput.value = option;
            answerLabel.appendChild(answerInput);

            // Adds a class to the answer labels to apply the styling
            answerLabel.classList.add("answer-label");

            answerLabel.appendChild(document.createTextNode(` ${question.answers[option]}`));

            // Decide which container to append the option based on the option name
            if (option === 'a' || option === 'b') {
                optionsABContainer.appendChild(answerLabel);
            } else {
                optionsCDCOntainer.appendChild(answerLabel);
            }
        }

        // Appends the option containers to the question element
        questionElement.appendChild(optionsABContainer);
        questionElement.appendChild(optionsCDCOntainer);

        quizForm.innerHTML = ""; // Clear the form before adding the new question
        quizForm.appendChild(questionElement);

        if (currentQuestionIndex === quizData.length - 1) {
            submitButton.textContent = "Submit"; // Changes the button text for the last question
        }
    } else {
        displayResult();
    }
}

function calculateScore() {
    const selectedAnswer = document.querySelector(`input[name="question${currentQuestionIndex}"]:checked`);
    if (selectedAnswer) {
        const selectedValue = selectedAnswer.value;
        if (selectedValue === quizData[currentQuestionIndex].correctAnswer) {
            score++;
        }
    }

    currentQuestionIndex++;
    displayQuestion();
}

function displayResult() {
    const resultText = `You scored ${score} out of ${quizData.length} questions.`;

    // quizForm container to displays the score
    quizForm.innerHTML = "";
    const resultElement = document.createElement("div");
    resultElement.classList.add("result");
    resultElement.textContent = resultText;
    quizForm.appendChild(resultElement);

    // Displays the section about HTML and CSS
    document.getElementById("quizResultsSection").style.display = "block";
	quizResultsSection.style.display = "flex";

    // Hides the submit button
    submitButton.style.display = "none";
}

submitButton.addEventListener("click", () => {
    if (currentQuestionIndex < quizData.length) {
        const selectedAnswer = document.querySelector(`input[name="question${currentQuestionIndex}"]:checked`);
        if (!selectedAnswer) {
            // Display an error message if no answer is selected.
            alert("Please select an answer before submitting.");
            return;
        }
        calculateScore();
    }
});

displayQuestion();